/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2artifacts.content.search.shape;

import dev.xkmc.l2artifacts.content.config.StatTypeConfig;
import dev.xkmc.l2artifacts.content.core.ArtifactStats;
import dev.xkmc.l2artifacts.content.core.BaseArtifact;
import dev.xkmc.l2artifacts.content.search.common.IFilterMenu;
import dev.xkmc.l2artifacts.content.search.shape.ShapeResultSlot;
import dev.xkmc.l2artifacts.content.search.shape.ShapeSlots;
import dev.xkmc.l2artifacts.content.search.token.ArtifactChestToken;
import dev.xkmc.l2artifacts.content.upgrades.ArtifactUpgradeManager;
import dev.xkmc.l2artifacts.content.upgrades.StatContainerItem;
import dev.xkmc.l2artifacts.content.upgrades.Upgrade;
import dev.xkmc.l2artifacts.content.upgrades.UpgradeBoostItem;
import dev.xkmc.l2artifacts.init.registrate.ArtifactMenuRegistry;
import dev.xkmc.l2artifacts.init.registrate.items.ArtifactItems;
import dev.xkmc.l2library.base.menu.base.BaseContainerMenu;
import dev.xkmc.l2library.base.menu.base.PredSlot;
import dev.xkmc.l2library.base.menu.base.SpriteManager;
import dev.xkmc.l2library.util.nbt.ItemCompoundTag;
import dev.xkmc.l2serial.serialization.codec.TagCodec;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ShapeMenu
extends BaseContainerMenu<ShapeMenu>
implements IFilterMenu {
    private static final SpriteManager MANAGER = new SpriteManager("l2artifacts", "shape");
    public final ArtifactChestToken token;
    public final Player player;

    public static ShapeMenu fromNetwork(MenuType<ShapeMenu> type, int wid, Inventory plInv, FriendlyByteBuf buf) {
        int i = buf.readInt();
        return new ShapeMenu(wid, plInv, ArtifactChestToken.of(plInv.f_35978_, i));
    }

    public ShapeMenu(int wid, Inventory plInv, ArtifactChestToken token) {
        super((MenuType)ArtifactMenuRegistry.MT_SHAPE.get(), wid, plInv, MANAGER, e -> new BaseContainerMenu.BaseContainer(15, (BaseContainerMenu)e).setMax(1), true);
        this.token = token;
        this.player = plInv.f_35978_;
        this.addResultSlot(ShapeSlots.OUTPUT.slot(), e -> false);
        this.addSlot(ShapeSlots.ARTIFACT_MAIN.slot(), e -> {
            Item patt2202$temp = e.m_41720_();
            if (!(patt2202$temp instanceof BaseArtifact)) {
                return false;
            }
            BaseArtifact art = (BaseArtifact)patt2202$temp;
            int rank = art.rank;
            Optional<ArtifactStats> opt = BaseArtifact.getStats(e);
            if (opt.isEmpty()) {
                return false;
            }
            return opt.get().level == ArtifactUpgradeManager.getMaxLevel(rank);
        });
        this.addSlot(ShapeSlots.BOOST_MAIN.slot(), e -> {
            if (this.getMainItem().m_41619_()) return false;
            Item patt2507$temp = e.m_41720_();
            if (!(patt2507$temp instanceof UpgradeBoostItem)) return false;
            UpgradeBoostItem boost = (UpgradeBoostItem)patt2507$temp;
            if (boost.rank != ((BaseArtifact)this.getMainItem().m_41720_()).rank) return false;
            if (boost.type != Upgrade.Type.BOOST_MAIN_STAT) return false;
            return true;
        }, s -> s.setInputLockPred(this::mainSlotsLocked));
        this.addSlot(ShapeSlots.ARTIFACT_SUB.slot(), this::isAllowedAsSubArtifact, (i, e) -> e.setInputLockPred(() -> this.subArtifactSlotLocked((int)i)));
        this.addSlot(ShapeSlots.STAT_SUB.slot(), (i, e) -> {
            ItemStack sub = ShapeSlots.ARTIFACT_SUB.get(this, (int)i).m_7993_();
            if (sub.m_41619_()) {
                return false;
            }
            BaseArtifact item = (BaseArtifact)sub.m_41720_();
            if (e.m_41720_() != ArtifactItems.ITEM_STAT[item.rank - 1].get()) {
                return false;
            }
            Optional<ResourceLocation> statOpt = StatContainerItem.getType(e);
            Optional<ArtifactStats> subOpt = BaseArtifact.getStats(sub);
            if (statOpt.isEmpty()) {
                return false;
            }
            if (subOpt.isEmpty()) {
                return false;
            }
            return subOpt.get().main_stat.type.equals((Object)statOpt.get());
        }, (i, s) -> s.setInputLockPred(() -> this.subMatSlotLocked((int)i)));
        this.addSlot(ShapeSlots.BOOST_SUB.slot(), (i, e) -> {
            ItemStack sub = ShapeSlots.ARTIFACT_SUB.get(this, (int)i).m_7993_();
            if (sub.m_41619_()) {
                return false;
            }
            BaseArtifact item = (BaseArtifact)sub.m_41720_();
            return e.m_41720_() == ArtifactItems.ITEM_BOOST_SUB[item.rank - 1].get();
        }, (i, s) -> s.setInputLockPred(() -> this.subMatSlotLocked((int)i)));
    }

    protected void addResultSlot(String name, Predicate<ItemStack> pred) {
        this.sprite.get().getSlot(name, (x, y) -> new ShapeResultSlot(this.container, this.added++, x, y, pred), (x$0, x$1, x$2, x$3) -> this.addSlot(x$0, x$1, x$2, x$3));
    }

    public PredSlot getAsPredSlot(ShapeSlots slot) {
        return super.getAsPredSlot(slot.slot());
    }

    public PredSlot getAsPredSlot(ShapeSlots slot, int i) {
        return super.getAsPredSlot(slot.slot(), i, 0);
    }

    private ItemStack getMainItem() {
        return ShapeSlots.ARTIFACT_MAIN.get(this).m_7993_();
    }

    private boolean mainSlotsLocked() {
        return this.getMainItem().m_41619_() || BaseArtifact.getStats(this.getMainItem()).isEmpty();
    }

    private boolean subArtifactSlotLocked(int i) {
        if (this.mainSlotsLocked()) {
            return true;
        }
        BaseArtifact mainItem = (BaseArtifact)this.getMainItem().m_41720_();
        int rank = mainItem.rank;
        return i >= rank - 1;
    }

    private boolean subMatSlotLocked(int i) {
        if (this.subArtifactSlotLocked(i)) {
            return true;
        }
        ItemStack sub = ShapeSlots.ARTIFACT_SUB.get(this, i).m_7993_();
        if (sub.m_41619_()) {
            return true;
        }
        Optional<ArtifactStats> subOpt = BaseArtifact.getStats(sub);
        return subOpt.isEmpty();
    }

    private boolean isAllowedAsSubArtifact(int index, ItemStack e) {
        ItemStack main = this.getMainItem();
        if (main.m_41619_()) {
            return false;
        }
        BaseArtifact mainItem = (BaseArtifact)this.getMainItem().m_41720_();
        Item item = e.m_41720_();
        if (!(item instanceof BaseArtifact)) {
            return false;
        }
        BaseArtifact eItem = (BaseArtifact)item;
        if (eItem.set.get() != mainItem.set.get()) {
            return false;
        }
        int rank = mainItem.rank;
        if (index >= rank - 1) {
            return false;
        }
        Optional<ArtifactStats> mainOpt = BaseArtifact.getStats(main);
        if (mainOpt.isEmpty()) {
            return false;
        }
        if (mainOpt.get().level < ArtifactUpgradeManager.getMaxLevel(rank)) {
            return false;
        }
        ResourceLocation mainType = mainOpt.get().main_stat.type;
        Optional<ArtifactStats> eOpt = BaseArtifact.getStats(e);
        if (eOpt.isEmpty()) {
            return false;
        }
        if (eOpt.get().level < ArtifactUpgradeManager.getMaxLevel(rank)) {
            return false;
        }
        ResourceLocation eType = eOpt.get().main_stat.type;
        if (mainType.equals((Object)eType)) {
            return false;
        }
        for (int i = 0; i < rank - 1; ++i) {
            ItemStack other;
            if (i == index || (other = ShapeSlots.ARTIFACT_SUB.get(this, i).m_7993_()).m_41619_()) continue;
            Optional<ArtifactStats> subOpt = BaseArtifact.getStats(other);
            assert (subOpt.isPresent());
            ResourceLocation subType = subOpt.get().main_stat.type;
            if (!subType.equals((Object)eType)) continue;
            return false;
        }
        return true;
    }

    protected void securedServerSlotChange(Container cont) {
        int i;
        ShapeSlots.BOOST_MAIN.get(this).updateEject(this.player);
        for (i = 0; i < 4; ++i) {
            ShapeSlots.ARTIFACT_SUB.get(this, i).updateEject(this.player);
        }
        for (i = 0; i < 4; ++i) {
            ShapeSlots.STAT_SUB.get(this, i).updateEject(this.player);
        }
        for (i = 0; i < 4; ++i) {
            ShapeSlots.BOOST_SUB.get(this, i).updateEject(this.player);
        }
        boolean outputChanged = ShapeSlots.OUTPUT.get(this).clearDirty();
        if (!this.getMainItem().m_41619_()) {
            int i2;
            BaseArtifact artifact = (BaseArtifact)this.getMainItem().m_41720_();
            int rank = artifact.rank;
            boolean pass = !ShapeSlots.BOOST_MAIN.get(this).m_7993_().m_41619_();
            for (i2 = 0; i2 < rank - 1; ++i2) {
                pass &= !ShapeSlots.ARTIFACT_SUB.get(this, i2).m_7993_().m_41619_();
                pass &= !ShapeSlots.STAT_SUB.get(this, i2).m_7993_().m_41619_();
                pass &= !ShapeSlots.BOOST_SUB.get(this, i2).m_7993_().m_41619_();
            }
            if (!outputChanged) {
                if (pass) {
                    ItemStack result = new ItemStack((ItemLike)artifact, 1);
                    RandomSource r = this.player.m_217043_();
                    ArtifactStats stat = new ArtifactStats(artifact.slot.get(), rank);
                    Optional<ArtifactStats> mainOpt = BaseArtifact.getStats(this.getMainItem());
                    assert (mainOpt.isPresent());
                    ResourceLocation mainStat = mainOpt.get().main_stat.type;
                    stat.add(mainStat, StatTypeConfig.get(mainStat).getInitialValue(r, true));
                    for (int i3 = 0; i3 < rank - 1; ++i3) {
                        Optional<ArtifactStats> subOpt = BaseArtifact.getStats(ShapeSlots.ARTIFACT_SUB.get(this, i3).m_7993_());
                        assert (subOpt.isPresent());
                        ResourceLocation subStat = subOpt.get().main_stat.type;
                        stat.add(subStat, StatTypeConfig.get(subStat).getInitialValue(r, true));
                    }
                    TagCodec.toTag((CompoundTag)ItemCompoundTag.of((ItemStack)result).getSubTag("ArtifactData").getOrCreate(), (Object)stat);
                    ShapeSlots.OUTPUT.get(this).m_5852_(result);
                } else {
                    ShapeSlots.OUTPUT.get(this).m_5852_(ItemStack.f_41583_);
                }
                ShapeSlots.OUTPUT.get(this).clearDirty();
            }
            if (outputChanged && pass) {
                ShapeSlots.ARTIFACT_MAIN.get(this).m_6201_(1);
                ShapeSlots.BOOST_MAIN.get(this).m_6201_(1);
                for (i2 = 0; i2 < rank - 1; ++i2) {
                    ShapeSlots.ARTIFACT_SUB.get(this, i2).m_6201_(1);
                    ShapeSlots.STAT_SUB.get(this, i2).m_6201_(1);
                    ShapeSlots.BOOST_SUB.get(this, i2).m_6201_(1);
                }
            }
        } else {
            ShapeSlots.OUTPUT.get(this).m_5852_(ItemStack.f_41583_);
            ShapeSlots.OUTPUT.get(this).clearDirty();
        }
    }

    public boolean m_6366_(Player player, int data) {
        return false;
    }

    protected boolean shouldClear(Container container, int slot) {
        return slot != 0;
    }
}

